/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.Memory;

class NativeMemory
implements Memory,
DirectMemory {
    protected static final MemoryIO IO = MemoryIO.getInstance();
    final NativeMemory parent;
    final long address;

    NativeMemory(long l) {
        this.address = l;
        this.parent = null;
    }

    private NativeMemory(NativeMemory nativeMemory, long l) {
        this.parent = nativeMemory;
        this.address = nativeMemory.address + l;
    }

    public final long getAddress() {
        return this.address;
    }

    public NativeMemory slice(long l) {
        return l == 0L ? this : new NativeMemory(this, l);
    }

    public final boolean equals(Object object) {
        return object instanceof DirectMemory && ((DirectMemory)object).getAddress() == this.address;
    }

    public final int hashCode() {
        int n = 5;
        n = 53 * n + (int)(this.address ^ this.address >>> 32);
        return n;
    }

    public final boolean isNull() {
        return this.address == 0L;
    }

    public final boolean isDirect() {
        return true;
    }

    public final byte getByte(long l) {
        return IO.getByte(this.address + l);
    }

    public final short getShort(long l) {
        return IO.getShort(this.address + l);
    }

    public final int getInt(long l) {
        return IO.getInt(this.address + l);
    }

    public final long getLong(long l) {
        return IO.getLong(this.address + l);
    }

    public final long getNativeLong(long l) {
        return Platform.getPlatform().longSize() == 32 ? (long)IO.getInt(this.address + l) : IO.getLong(this.address + l);
    }

    public final float getFloat(long l) {
        return IO.getFloat(this.address + l);
    }

    public final double getDouble(long l) {
        return IO.getDouble(this.address + l);
    }

    public final long getAddress(long l) {
        return IO.getAddress(this.address + l);
    }

    public final DirectMemory getMemory(long l) {
        long l2 = IO.getAddress(this.address + l);
        return l2 != 0L ? new NativeMemory(l2) : null;
    }

    public final byte[] getZeroTerminatedByteArray(long l) {
        return IO.getZeroTerminatedByteArray(this.address + l);
    }

    public void putZeroTerminatedByteArray(long l, byte[] byArray, int n, int n2) {
        IO.putZeroTerminatedByteArray(this.address + l, byArray, n, n2);
    }

    public final void putByte(long l, byte by) {
        IO.putByte(this.address + l, by);
    }

    public final void putShort(long l, short s) {
        IO.putShort(this.address + l, s);
    }

    public final void putInt(long l, int n) {
        IO.putInt(this.address + l, n);
    }

    public final void putLong(long l, long l2) {
        IO.putLong(this.address + l, l2);
    }

    public final void putNativeLong(long l, long l2) {
        if (Platform.getPlatform().longSize() == 32) {
            IO.putInt(this.address + l, (int)l2);
        } else {
            IO.putLong(this.address + l, l2);
        }
    }

    public final void putAddress(long l, long l2) {
        IO.putAddress(this.address + l, l2);
    }

    public final void putFloat(long l, float f) {
        IO.putFloat(this.address + l, f);
    }

    public final void putDouble(long l, double d) {
        IO.putDouble(this.address + l, d);
    }

    public final void putAddress(long l, Memory memory) {
        IO.putAddress(this.address + l, ((DirectMemory)memory).getAddress());
    }

    public final void get(long l, byte[] byArray, int n, int n2) {
        IO.getByteArray(this.address + l, byArray, n, n2);
    }

    public final void put(long l, byte[] byArray, int n, int n2) {
        IO.putByteArray(this.address + l, byArray, n, n2);
    }

    public final void get(long l, short[] sArray, int n, int n2) {
        IO.getShortArray(this.address + l, sArray, n, n2);
    }

    public final void put(long l, short[] sArray, int n, int n2) {
        IO.putShortArray(this.address + l, sArray, n, n2);
    }

    public final void get(long l, int[] nArray, int n, int n2) {
        IO.getIntArray(this.address + l, nArray, n, n2);
    }

    public final void put(long l, int[] nArray, int n, int n2) {
        IO.putIntArray(this.address + l, nArray, n, n2);
    }

    public final void get(long l, long[] lArray, int n, int n2) {
        IO.getLongArray(this.address + l, lArray, n, n2);
    }

    public final void put(long l, long[] lArray, int n, int n2) {
        IO.putLongArray(this.address + l, lArray, n, n2);
    }

    public final void get(long l, float[] fArray, int n, int n2) {
        IO.getFloatArray(this.address + l, fArray, n, n2);
    }

    public final void put(long l, float[] fArray, int n, int n2) {
        IO.putFloatArray(this.address + l, fArray, n, n2);
    }

    public final void get(long l, double[] dArray, int n, int n2) {
        IO.getDoubleArray(this.address + l, dArray, n, n2);
    }

    public final void put(long l, double[] dArray, int n, int n2) {
        IO.putDoubleArray(this.address + l, dArray, n, n2);
    }

    public final int indexOf(long l, byte by) {
        return by == 0 ? (int)IO.getStringLength(this.address + l) : (int)IO.indexOf(this.address + l, by);
    }

    public final int indexOf(long l, byte by, int n) {
        return (int)IO.indexOf(this.address, by, n);
    }

    public final void setMemory(long l, long l2, byte by) {
        IO.setMemory(this.address + l, l2, by);
    }
}

